/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_AGENDA_SUPRIMENTO_GRUPO]    Script Date: 12/02/2015 07:10:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_AGENDA_SUPRIMENTO_GRUPO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_AGENDA_SUPRIMENTO_GRUPO]
GO
GO
GO
GO
GO

--agendado para data futura ou atrasado dentro do permitido, deixa a data atual
--atrasado fora do limite, calcula a data que encaixa dentro do permitido
--EXECUTE P_ATUALIZA_AGENDA_SUPRIMENTO_GRUPO
CREATE PROCEDURE [dbo].[P_ATUALIZA_AGENDA_SUPRIMENTO_GRUPO] AS
DECLARE @ajuste TABLE (CD_EMP INT, CD_CTR_GRUPO INT, FREQ_REV INT, DT_PROX DATETIME);
DECLARE @hoje DATETIME;
SET @hoje=dbo.F_DIA(GETDATE());
WITH 
	ENTREGA AS ( --Para entregas sem periodo fechado (8,12), h o calculo do dia da semana
		SELECT CD_CTR_GRUPO, DIA_SEMANA=2 FROM EST_PROD_FABRIC_GRUPO WHERE SEGUNDA=1 AND FREQ_REV IN (8,12) AND FLAG_GERAR_AGENDA=0
	  UNION ALL
		SELECT CD_CTR_GRUPO, DIA_SEMANA=3 FROM EST_PROD_FABRIC_GRUPO WHERE TERCA=1 AND FREQ_REV IN (8,12) AND FLAG_GERAR_AGENDA=0
	  UNION ALL
		SELECT CD_CTR_GRUPO, DIA_SEMANA=4 FROM EST_PROD_FABRIC_GRUPO WHERE QUARTA=1 AND FREQ_REV IN (8,12) AND FLAG_GERAR_AGENDA=0
	  UNION ALL
		SELECT CD_CTR_GRUPO, DIA_SEMANA=5 FROM EST_PROD_FABRIC_GRUPO WHERE QUINTA=1 AND FREQ_REV IN (8,12) AND FLAG_GERAR_AGENDA=0
	  UNION ALL
		SELECT CD_CTR_GRUPO, DIA_SEMANA=6 FROM EST_PROD_FABRIC_GRUPO WHERE SEXTA=1 AND FREQ_REV IN (8,12) AND FLAG_GERAR_AGENDA=0),
	ENTREGA2 AS (--se nao houve dia de entrega prevista na semana, pega no semana anterior
		SELECT CD_CTR_GRUPO, DIA_SEMANA FROM ENTREGA
	  UNION ALL --semana atual: seg=2, ter=3, ..., sex=6; semana_anterior:seg=-5, ter=-4, ..., sex=-1
		SELECT CD_CTR_GRUPO, DIA_SEMANA=DIA_SEMANA-7 FROM ENTREGA),
	BASE1 AS (--calcula o periodo se frequencia  1,2,4 ou 28
		SELECT 
			CD_EMP=1, 
			f.CD_CTR_GRUPO, 
			f.FREQ_REV,
			DIA_SEMANA = DATEPART(WEEKDAY, @hoje), 
			DT_BASE = CASE  WHEN FREQ_REV IN (1,2,4) THEN a.DT_AGENDAMENTO 
							WHEN a.DT_AGENDAMENTO > f.DT_AGENDAMENTO_DEFAULT THEN a.DT_AGENDAMENTO
							ELSE f.DT_AGENDAMENTO_DEFAULT END,
			PERIODO = CASE WHEN FREQ_REV IN (1,2,4,28) THEN 28/FREQ_REV END			
		FROM 
			EST_PROD_FABRIC_GRUPO f 
			INNER JOIN EST_PROD_FABRIC_AGENDA_GRUPO A ON 
			f.CD_CTR_GRUPO=a.CD_CTR_GRUPO
		WHERE 
			f.FLAG_GERAR_AGENDA=0 
			AND f.INDICADOR_SUPRIMENTO = 1),
	BASE2 AS (--calcula o atraso, se existir; para fequencias 8,12, calcula o dia da semana da ultima entrega prevista
		SELECT 
			CD_EMP, CD_CTR_GRUPO, PERIODO, DIA_SEMANA, FREQ_REV, DT_BASE,
			ATRASO=DATEDIFF(DAY, DT_BASE, @hoje),
			ATRASO_PERMITIDO=ISNULL(PERIODO-1, 0),
			ULT_DIA=(SELECT MAX(DIA_SEMANA) FROM ENTREGA2  --ltima entrega passada (dia da semana)
					 WHERE CD_CTR_GRUPO=b.CD_CTR_GRUPO AND DIA_SEMANA<=b.DIA_SEMANA)
		FROM 
			BASE1 b),
	BASE3 AS (
		SELECT	CD_EMP, CD_CTR_GRUPO, FREQ_REV, ATRASO, DT_BASE,
				QT_DIAS = CASE  WHEN ATRASO<=ATRASO_PERMITIDO THEN NULL	--sem atraso ou dentro do permitido, mantm data
								WHEN PERIODO IS NOT NULL THEN -ATRASO%PERIODO	--dias para a prxima entrega prevista
								ELSE ULT_DIA-DIA_SEMANA END						--idem 
		FROM BASE2)
	INSERT INTO @ajuste (CD_EMP, CD_CTR_GRUPO, FREQ_REV, DT_PROX) 
		SELECT CD_EMP, CD_CTR_GRUPO, FREQ_REV, DT_PROX=ISNULL(DATEADD(DAY, QT_DIAS, @hoje), DT_BASE)
		FROM BASE3;
BEGIN TRANSACTION---------------------------------------------------------------------------------------------------
UPDATE b SET STATUS=1 
	FROM @ajuste a JOIN EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO b ON b.CD_EMP=a.CD_EMP AND b.CD_CTR_GRUPO=a.CD_CTR_GRUPO 
	WHERE b.DT_AGENDA<>a.DT_PROX AND STATUS=0;
INSERT INTO EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO (CD_EMP, CD_AGENDA, CD_CTR_GRUPO, DT_AGENDA, STATUS)
	SELECT	CD_EMP, 
			CD_AGENDA=ISNULL((SELECT MAX(CD_AGENDA) FROM EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO WITH (XLOCK)
							  WHERE CD_EMP=a.CD_EMP), 0)
					  + ROW_NUMBER() OVER (PARTITION BY CD_EMP ORDER BY CD_CTR_GRUPO),
			CD_CTR_GRUPO, DT_AGENDA=DT_PROX, STATUS=0 
	FROM @ajuste a
	WHERE NOT EXISTS (SELECT * FROM EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO 
					  WHERE CD_EMP=a.CD_EMP AND CD_CTR_GRUPO=a.CD_CTR_GRUPO AND STATUS=0);
INSERT INTO EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA_GRUPO
		(CD_EMP, CD_CTR, CD_OCORRENCIA, CD_EVENTO, CD_TP_EVENTO, CD_CTR_GRUPO, CD_AGENDA, QTDE, DT_PREV_CP, CD_COMPRADOR, 
		 DT_CAD)
	SELECT 
		a.CD_EMP, 
		CD_CTR=ISNULL((SELECT MAX(CD_CTR) FROM EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA_GRUPO WITH (XLOCK) 
					   WHERE CD_EMP=a.CD_EMP), 0)
			   + ROW_NUMBER() OVER (PARTITION BY a.CD_EMP ORDER BY a.CD_CTR_GRUPO),
		CD_OCORRENCIA=ISNULL((SELECT MAX(CD_OCORRENCIA) FROM EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA WITH (XLOCK) 
							  WHERE CD_EMP=a.CD_EMP AND CD_AGENDA=a.CD_AGENDA), 0)
					  +ROW_NUMBER() OVER (PARTITION BY a.CD_EMP, a.CD_AGENDA ORDER BY a.CD_CTR_GRUPO),
		CD_EVENTO=3, --ATRASO
		CD_TP_EVENTO=1, --ATRASO
		CD_CTR_GRUPO = a.CD_CTR_GRUPO,
		CD_AGENDA = a.CD_AGENDA,
		QTDE = DATEDIFF(day, a.DT_AGENDA, @hoje),
		DT_PREV_CP = a.DT_AGENDA + f.LEAD_TIME,
		f.CD_COMPRADOR,
		DT_CAD=GETDATE()
	FROM EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO a JOIN EST_PROD_FABRIC_GRUPO f ON f.CD_CTR_GRUPO=a.CD_CTR_GRUPO
	WHERE a.STATUS=0 AND a.DT_AGENDA<@hoje 
	AND f.INDICADOR_SUPRIMENTO=1
	AND f.FLAG_GERAR_AGENDA=0
	AND NOT EXISTS --agenda atual, data com atraso e no cadastrou hoje
		(SELECT * FROM EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA_GRUPO --No registra mais de uma vez por dia
		 WHERE CD_EMP=a.CD_EMP AND CD_CTR_GRUPO=a.CD_CTR_GRUPO AND DT_CAD>=@hoje);
--Alterando data agendamento Default para controle do cadastro
UPDATE
	EST_PROD_FABRIC_GRUPO
SET 
	DT_AGENDAMENTO_DEFAULT=EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO.DT_AGENDA
from
	EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO INNER JOIN EST_PROD_FABRIC_GRUPO ON
	EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO.CD_CTR_GRUPO = EST_PROD_FABRIC_GRUPO.CD_CTR_GRUPO
WHERE
	EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO.STATUS=0
	AND DT_AGENDAMENTO_DEFAULT<>EST_PED_ELTR_SUPRIMENTO_AGENDA_GRUPO.DT_AGENDA
COMMIT  TRANSACTION---------------------------------------------------------------------------------------------------


